/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class MainSettingsConfig {
    private static final ForgeConfigSpec SPEC;
    private static final MainSettingsConfig INSTANCE;
    private static final ForgeConfigSpec.Builder BUILDER;
    public static final ForgeConfigSpec.ConfigValue<Integer> DIFFICULTY;
    public static final ForgeConfigSpec.ConfigValue<String> VERSION;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_HABITABLE_TEMPERATURE;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_HABITABLE_TEMPERATURE;
    public static final ForgeConfigSpec.ConfigValue<Double> TEMP_RATE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> TEMP_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FIRE_RESISTANCE_BLOCKS_OVERHEATING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ICE_RESISTANCE_BLOCKS_FREEZING;
    public static final ForgeConfigSpec.ConfigValue<Boolean> NULLIFY_IN_PEACEFUL;
    public static final ForgeConfigSpec.ConfigValue<Boolean> REQUIRE_THERMOMETER;
    public static final ForgeConfigSpec.ConfigValue<Integer> GRACE_PERIOD_LENGTH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_GRACE_PERIOD;
    public static final ForgeConfigSpec.ConfigValue<Double> HEATSTROKE_FOG;
    public static final ForgeConfigSpec.ConfigValue<Double> FREEZING_HEARTS;
    public static final ForgeConfigSpec.ConfigValue<Double> COLD_KNOCKBACK;
    public static final ForgeConfigSpec.ConfigValue<Double> COLD_MINING;
    public static final ForgeConfigSpec.ConfigValue<Double> COLD_MOVEMENT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DISABLED_TEMP_MODIFIERS;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/main.toml");
    }

    public static MainSettingsConfig getInstance() {
        return INSTANCE;
    }

    public String getVersion() {
        return (String)VERSION.get();
    }

    public int getDifficulty() {
        return (Integer)DIFFICULTY.get();
    }

    public boolean isFireResistanceEnabled() {
        return (Boolean)FIRE_RESISTANCE_BLOCKS_OVERHEATING.get();
    }

    public boolean isIceResistanceEnabled() {
        return (Boolean)ICE_RESISTANCE_BLOCKS_FREEZING.get();
    }

    public boolean thermometerRequired() {
        return (Boolean)REQUIRE_THERMOMETER.get();
    }

    public boolean nullifyInPeaceful() {
        return (Boolean)NULLIFY_IN_PEACEFUL.get();
    }

    public double getTempDamage() {
        return (Double)TEMP_DAMAGE.get();
    }

    public double getMinTempHabitable() {
        return (Double)MIN_HABITABLE_TEMPERATURE.get();
    }

    public double getMaxTempHabitable() {
        return (Double)MAX_HABITABLE_TEMPERATURE.get();
    }

    public double getRateMultiplier() {
        return (Double)TEMP_RATE_MULTIPLIER.get();
    }

    public int getGracePeriodLength() {
        return (Integer)GRACE_PERIOD_LENGTH.get();
    }

    public boolean isGracePeriodEnabled() {
        return (Boolean)ENABLE_GRACE_PERIOD.get();
    }

    public double getHeatstrokeFogDistance() {
        return (Double)HEATSTROKE_FOG.get();
    }

    public double getHeartsFreezingPercentage() {
        return (Double)FREEZING_HEARTS.get();
    }

    public double getColdKnockbackReduction() {
        return (Double)COLD_KNOCKBACK.get();
    }

    public double getColdMiningImpairment() {
        return (Double)COLD_MINING.get();
    }

    public double getColdMovementSlowdown() {
        return (Double)COLD_MOVEMENT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setVersion(String version) {
        ForgeConfigSpec.ConfigValue<String> configValue = VERSION;
        synchronized (configValue) {
            VERSION.set((Object)version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDifficulty(int value) {
        ForgeConfigSpec.ConfigValue<Integer> configValue = DIFFICULTY;
        synchronized (configValue) {
            DIFFICULTY.set((Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaxHabitable(double temp) {
        ForgeConfigSpec.ConfigValue<Double> configValue = MAX_HABITABLE_TEMPERATURE;
        synchronized (configValue) {
            MAX_HABITABLE_TEMPERATURE.set((Object)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMinHabitable(double temp) {
        ForgeConfigSpec.ConfigValue<Double> configValue = MIN_HABITABLE_TEMPERATURE;
        synchronized (configValue) {
            MIN_HABITABLE_TEMPERATURE.set((Object)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRateMultiplier(double rate) {
        ForgeConfigSpec.ConfigValue<Double> configValue = TEMP_RATE_MULTIPLIER;
        synchronized (configValue) {
            TEMP_RATE_MULTIPLIER.set((Object)rate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFireResistanceEnabled(boolean isEffective) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = FIRE_RESISTANCE_BLOCKS_OVERHEATING;
        synchronized (configValue) {
            FIRE_RESISTANCE_BLOCKS_OVERHEATING.set((Object)isEffective);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setIceResistanceEnabled(boolean isEffective) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = ICE_RESISTANCE_BLOCKS_FREEZING;
        synchronized (configValue) {
            ICE_RESISTANCE_BLOCKS_FREEZING.set((Object)isEffective);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRequireThermometer(boolean required) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = REQUIRE_THERMOMETER;
        synchronized (configValue) {
            REQUIRE_THERMOMETER.set((Object)required);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setNullifyInPeaceful(boolean enabled) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = NULLIFY_IN_PEACEFUL;
        synchronized (configValue) {
            NULLIFY_IN_PEACEFUL.set((Object)enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTempDamage(double damage) {
        ForgeConfigSpec.ConfigValue<Double> configValue = TEMP_DAMAGE;
        synchronized (configValue) {
            TEMP_DAMAGE.set((Object)damage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setGracePeriodLength(int ticks) {
        ForgeConfigSpec.ConfigValue<Integer> configValue = GRACE_PERIOD_LENGTH;
        synchronized (configValue) {
            GRACE_PERIOD_LENGTH.set((Object)ticks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setGracePeriodEnabled(boolean enabled) {
        ForgeConfigSpec.ConfigValue<Boolean> configValue = ENABLE_GRACE_PERIOD;
        synchronized (configValue) {
            ENABLE_GRACE_PERIOD.set((Object)enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHeatstrokeFogDistance(double distance) {
        ForgeConfigSpec.ConfigValue<Double> configValue = HEATSTROKE_FOG;
        synchronized (configValue) {
            HEATSTROKE_FOG.set((Object)distance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHeartsFreezingPercentage(double percent) {
        ForgeConfigSpec.ConfigValue<Double> configValue = FREEZING_HEARTS;
        synchronized (configValue) {
            FREEZING_HEARTS.set((Object)percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdKnockbackReduction(double amount) {
        ForgeConfigSpec.ConfigValue<Double> configValue = COLD_KNOCKBACK;
        synchronized (configValue) {
            COLD_KNOCKBACK.set((Object)amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdMiningImpairment(double amount) {
        ForgeConfigSpec.ConfigValue<Double> configValue = COLD_MINING;
        synchronized (configValue) {
            COLD_MINING.set((Object)amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColdMovementSlowdown(double amount) {
        ForgeConfigSpec.ConfigValue<Double> configValue = COLD_MOVEMENT;
        synchronized (configValue) {
            COLD_MOVEMENT.set((Object)amount);
        }
    }

    public void save() {
        SPEC.save();
    }

    static {
        INSTANCE = new MainSettingsConfig();
        BUILDER = new ForgeConfigSpec.Builder();
        ConfigSettings.Difficulty defaultDiff = ConfigSettings.DEFAULT_DIFFICULTY;
        BUILDER.comment("DO NOT EDIT THE SETTINGS IN THIS SECTION").push("Builtin");
        DIFFICULTY = BUILDER.defineInRange("Difficulty", defaultDiff.ordinal(), 0, ConfigSettings.Difficulty.values().length - 1);
        VERSION = BUILDER.define("Version", (Object)"");
        BUILDER.pop();
        BUILDER.push("Difficulty");
        MIN_HABITABLE_TEMPERATURE = BUILDER.comment("Defines the minimum habitable temperature").defineInRange("Minimum Habitable Temperature", defaultDiff.getOrDefault(ConfigSettings.MIN_TEMP, Double.valueOf(Temperature.convert(50.0, Temperature.Units.F, Temperature.Units.MC, true))).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        MAX_HABITABLE_TEMPERATURE = BUILDER.comment("Defines the maximum habitable temperature").defineInRange("Maximum Habitable Temperature", defaultDiff.getOrDefault(ConfigSettings.MAX_TEMP, Double.valueOf(Temperature.convert(100.0, Temperature.Units.F, Temperature.Units.MC, true))).doubleValue(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        TEMP_RATE_MULTIPLIER = BUILDER.comment("Rate at which the player's body temperature changes (default: 1.0 (100%))").defineInRange("Rate Multiplier", defaultDiff.getOrDefault(ConfigSettings.TEMP_RATE, Double.valueOf(1.0)).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        TEMP_DAMAGE = BUILDER.comment("Damage dealt to the player when they are too hot or too cold").defineInRange("Temperature Damage", defaultDiff.getOrDefault(ConfigSettings.TEMP_DAMAGE, Double.valueOf(2.0)).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        NULLIFY_IN_PEACEFUL = BUILDER.comment("Sets whether damage scales with difficulty").define("Damage Scaling", (Object)defaultDiff.getOrDefault("damage_scaling", Boolean.valueOf(true)));
        BUILDER.pop();
        BUILDER.push("Items");
        FIRE_RESISTANCE_BLOCKS_OVERHEATING = BUILDER.comment("Allow fire resistance to block overheating damage").define("Fire Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.FIRE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        ICE_RESISTANCE_BLOCKS_FREEZING = BUILDER.comment("Allow ice resistance to block freezing damage").define("Ice Resistance Immunity", (Object)defaultDiff.getOrDefault(ConfigSettings.ICE_RESISTANCE_ENABLED, Boolean.valueOf(true)));
        REQUIRE_THERMOMETER = BUILDER.comment("Thermometer item is required to see detailed world temperature").define("Require Thermometer", (Object)defaultDiff.getOrDefault(ConfigSettings.REQUIRE_THERMOMETER, Boolean.valueOf(true)));
        BUILDER.pop();
        BUILDER.push("Temperature Effects");
        BUILDER.push("Hot");
        HEATSTROKE_FOG = BUILDER.comment(new String[]{"Defines the distance at which the player's vision is obscured by heatstroke fog", "Set to a value above 64 to disable the effect"}).defineInRange("Heatstroke Fog", defaultDiff.getOrDefault(ConfigSettings.HEATSTROKE_FOG_DISTANCE, Double.valueOf(6.0)).doubleValue(), 0.0, Double.POSITIVE_INFINITY);
        BUILDER.pop();
        BUILDER.push("Cold");
        FREEZING_HEARTS = BUILDER.comment(new String[]{"When set to true, this percentage of the player's hearts will freeze over when they are too cold, preventing regeneration", "Represented as a percentage"}).defineInRange("Freezing Hearts Percentage", defaultDiff.getOrDefault(ConfigSettings.HEARTS_FREEZING_PERCENTAGE, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        COLD_KNOCKBACK = BUILDER.comment(new String[]{"When set to true, the player's attack knockback will be reduced by this amount when they are too cold", "Represented as a percentage"}).defineInRange("Chilled Knockback Reduction", defaultDiff.getOrDefault(ConfigSettings.COLD_KNOCKBACK_REDUCTION, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        COLD_MOVEMENT = BUILDER.comment(new String[]{"When set to true, the player's movement speed will be reduced by this amount when they are too cold", "Represented as a percentage"}).defineInRange("Chilled Movement Slowdown", defaultDiff.getOrDefault(ConfigSettings.COLD_MOVEMENT_SLOWDOWN, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        COLD_MINING = BUILDER.comment(new String[]{"When set to true, the player's mining speed will be reduced by this amount when they are too cold", "Represented as a percentage"}).defineInRange("Chilled Mining Speed Reduction", defaultDiff.getOrDefault(ConfigSettings.COLD_MINING_IMPAIRMENT, Double.valueOf(0.5)).doubleValue(), 0.0, 1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Grace Period");
        GRACE_PERIOD_LENGTH = BUILDER.comment("The amount of time (in ticks) after the player spawns during which they are immune to temperature effects").defineInRange("Grace Period Length", defaultDiff.getOrDefault(ConfigSettings.GRACE_LENGTH, Integer.valueOf(6000)).intValue(), 0, Integer.MAX_VALUE);
        ENABLE_GRACE_PERIOD = BUILDER.comment("Enables the grace period").define("Grace Period Enabled", (Object)defaultDiff.getOrDefault(ConfigSettings.GRACE_ENABLED, Boolean.valueOf(true)));
        BUILDER.pop();
        BUILDER.push("Misc");
        DISABLED_TEMP_MODIFIERS = BUILDER.comment(new String[]{"Add TempModifier IDs to this list to disable them", "Allows for more granular control of Cold Sweat's features", " Run \"/temp debug @s <trait>\" to see IDs of all modifiers affecting the player", "", " List of \"Vanilla\" TempModifier IDs:", " cold_sweat:blocks - Disables temperature emitted by blocks", " cold_sweat:biomes - Disables biome temperature (makes all biomes temperate)", " cold_sweat:underground - Disables temperature changes caused by depth / altitude", " cold_sweat:armor - Disables armor insulation", " cold_sweat:mount - Disables insulation from riding an entity", " cold_sweat:waterskin - Disables the waterskin's temperature effects", " cold_sweat:soulspring_lamp - Disables the cooling effect of the soulspring lamp", " cold_sweat:water - Disables the cooling effect of water, and the dripping particles from when the player is wet", " cold_sweat:air_conditioning - Disables the Warmth and Chill effects from the hearth, boiler, and icebox", " cold_sweat:food - Disables temperature effects from eating food", " cold_sweat:freezing - Disables the cooling effect of powder snow", " cold_sweat:on_fire - Disables the heating effect of being on fire", " cold_sweat:soul_sprout - Disables the effects of eating a soul sprout (separate from cold_sweat:food)", " cold_sweat:inventory_items - Disables the temperature effects of items in the player's inventory", " cold_sweat:entities - Disables the temperature emitted from entities", " sereneseasons:season - Disables the temperature effects of seasons from Serene Seasons", " armorunder:lining - Disables the temperature effects of armor linings from Armor Underwear", " weather2:storm - Disables the temperature effects of storms & weather from Weather 2", " curios:curios - Disables the temperature effects of equipped curios"}).defineListAllowEmpty(List.of("Disabled Temperature Modifiers"), () -> List.of(), o -> o instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

